using System;

namespace gov.va.med.vbecs.BOL
{

    #region Header

    ///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
    ///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
    ///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
    ///<Developers>
    ///	<Developer>Greg Lohse</Developer>
    ///</Developers>
    ///<SiteName>Hines OIFO</SiteName>
    ///<CreationDate>12/02/2008</CreationDate>
    ///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
    ///<summary>VbecsVersion - Created for CR2465</summary>

    #endregion


    public class VbecsVersion
    {
        private static string _currentVersion = string.Empty;

        ///<Developers>
        ///<Developer>Greg Lohse</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>12/2/2008</CreationDate>
        ///<TestCases>
        ///<Case type="0" testid ="8852"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>Version as string</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="8853"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        /// <summary>
        /// Returns the current Version of VBECS from the VbecsVersion table
        /// </summary>
        public static string CurrentVersion
        {
            get
            {
                if (_currentVersion == string.Empty)
                {
                    System.Data.DataTable dtVersion = DAL.VbecsVersion.GetVbecsVersion();

                    if (dtVersion.Rows.Count == 0)
                    {
                        //What should we do if there are no records found?
                        _currentVersion = "NOT FOUND";
                    }
                    else
                    {
                        _currentVersion = dtVersion.Rows[0][Common.VbecsTables.VbecsVersion.Version].ToString();
                    }
                }

                return (_currentVersion);
            }
        }

        ///<Developers>
        ///<Developer>Carrie Van Stedum</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>12/2/2008</CreationDate>
        ///<TestCases>
        ///<Case type="0" testid ="8852"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>Version as string</ExpectedOutput>
        ///	</Case>
        ///
        ///<Case type="1" testid ="8853"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        /// <summary>
        /// Returns the current Revision of VBECS from the VbecsVersion table CR 3453
        /// </summary>
        public static string CurrentRevision
        {
            get
            {
                string tmpRevision = "NOT FOUND";

                //Always real-time query since patches can be pushed w/o kicking off users
                System.Data.DataTable dtRevision = DAL.VbecsVersion.GetVbecsRevision();

                if (dtRevision.Rows.Count == 0)
                {
                    //WE should always start with Revision "A"
                    tmpRevision = "NOT FOUND";
                }
                else
                {
                    tmpRevision = dtRevision.Rows[0][Common.VbecsTables.VbecsDBRevision.Revision].ToString();
                }

                return (tmpRevision);
            }
        }
    }
}

